;=====================================================================
;                       PCTOOLS PLUGINS SDK
;                (c) Benoit SCHERRER, NeXO Software
;
;---------------------------------------------------------------------
; PLUGINS SDK VERSION   : 1.20
; FILE DESCRIPTION      : Typical Pctools Plugin Program 
;=====================================================================

	include "tios.h"                ;library includes files
	include "flib.h"

	xdef    _main                   ;normal assembly program
	xdef    _comment

	include "pctplug.h"             ;We must include pctplug.h before
					;any other assembly code

;--------------------------------------------------------------------
; Header of PCTOOLS plugin
;--------------------------------------------------------------------
	PRG_AS_PLUGIN


EXTENSION_FILTER:
	dc.b	0
	ds.w	0


PLUGIN_TABLE:
	dc.l	NOT_USED		;start_of_pct
	dc.l	NOT_USED		;end_of_pct
	dc.l	NOT_USED		;key_pressed
	dc.l	NOT_USED		;key_pressed_first
	dc.l	NOT_USED		;enter_pressed
	dc.l	NOT_USED		;cursor_moved
	dc.l	NOT_USED		;draw_item
	dc.l	NOT_USED		;menu_string
	dc.l	NOT_USED		;menu_function
	dc.l	NOT_USED		;compression_service
	dc.l	NOT_USED		;hide_menu




;--------------------------------------------------------------------
; Normal launch of the program
;--------------------------------------------------------------------
END_PLUGIN_TABLE:
	;(...)                          the program can continue
	rts


;---------------------------------------------------------------------
; Format of the PluginParameters structure :
; ( 28 bytes length )
;
; 00.w	:	return value 1, reserved
; 02.l	:	User parameter and return value2
; 06.w	:	Zero based index of selected item
;		in the list buffer
; 08.w	: 	Zero based index of selected item on
;		the screen
; 10.l	:	Address of selected item VAT entry in the buffer
; 14.w	:	Selected items counter
; 16.w	:	Handle of buffer list used
; 18.w	:	Real handle of current folder
; 20.w	:	Handle of selected item
; 22.w	:	reserved, for futur functions
; 24.l	:	reserved, for futur functions
;---------------------------------------------------------------------


;---------------------------------------------------------------------
; Function called when PCTOOLS is initializing.
;
;Input> 
;Out>  
;
;RETURN> SKIP_PCTPROCESS : request end of pct98
;---------------------------------------------------------------------
;InitializePCT:
;
;       rtplugin 0


;---------------------------------------------------------------------
; Function called when PCTOOLS is terminating.
;
;Input> 
;Out>
;
;RETURN> SKIP_PCTPROCESS : request NO end of PCT
;---------------------------------------------------------------------
;TerminateEndPCT:
;
;       rtplugin 0

;---------------------------------------------------------------------
; Function called when a key is pressed in PCT
;
; Notice that this function will be execute only if PCT
; itself doesn't already use this keycode.
;
; USE SPECIFIC EXTENSION
;
;Input>	a0.l : Address of a PluginParameters structure
;		04(a0).w : Value of keycode
;Out>
;
;RETURN> REDRAW_SCREEN : request to redraw the screen
;	 SHOW_MESSAGE : request to print a message in the
;	  status bar. The message is pointed by rg2 and must
;	  be valid
;---------------------------------------------------------------------
;KeyPressed:
;
;       rtplugin 0


;---------------------------------------------------------------------
; Function called when ENTER is pressed on a File/Folder,
; before PCT uses it 
;
; USE SPECIFIC EXTENSION
;
;Input>	a0.l : Address of a PluginParameters structure
;Out>
;
;RETURN> REDRAW_SCREEN : request to redraw the screen
;	 SHOW_MESSAGE : request to print a message in the
;	  status bar. The message is pointed by rg2 and must
;	  be valid
;	 SKIP_PCTPROCESS : request that PCT don't run its
;	  KeyEnter subroutine
;---------------------------------------------------------------------
;KeyEnter:
;
;       rtplugin 0


;---------------------------------------------------------------------
; Function called when the cursor is moved to a new item
;
; USE SPECIFIC EXTENSION
;
;Input>	a0.l : Address of a PluginParameters structure
;Out>
;
;RETURN> SHOW_MESSAGE : request to print a message in the
;	  status bar. The message is pointed by rg2 and must
;	  be valid
;	 SKIP_PCTPROCESS : request that PCT don't print something
;	  in the status bar
;---------------------------------------------------------------------
;CursorMoved:
;
;       rtplugin 0


;---------------------------------------------------------------------
; Function called when PCT show items on the screen
;
; USE SPECIFIC EXTENSION
;
;Input>	a0.l : Address of a PluginParameters structure
;		04(a0).w : Y screen position of item
;Out>
;
;RETURN> SKIP_PCTPROCESS : request that PCT98 don't run its
;	  ShowItem subroutine
;---------------------------------------------------------------------
;ShowItem:
;
;       rtplugin 0



;====================================================================
; Plugin Data
;====================================================================


_comment
	dc.b    "PCTOOLS Plugin",0

	end

